% rotate 2nd order tensor given rotation matrix T
%  S_ij = T_mi T_nj S_mn (sum over m,n)
%
% Wei Cai
% ME340 Elasticity of Microscopic Structures, Stanford University, Winter 2006
%
function Sp = rotate_elast_stiff(S,T)

Sp = zeros(size(S));

for i=1:3,
 for j=1:3,
       for m=1:3,
        for n=1:3,
              Sp(i,j)=Sp(i,j)+T(m,i)*T(n,j)*S(m,n);
        end
       end
 end
end
