%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%File: input_Mjunct.m
%
%Purpose: input file for DDLab simulation
%         formation of multi-junction
%        
%Run by:
%         input_Mjunct
%         dd3d
%
%To continue simulation, type:
%         dd3d
%
%   Section 10.4 Topological Changes
%
%Computer Simulations of Dislocations
%Wei Cai (caiwei@stanford.edu)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

totalsteps=400;

appliedstress=zeros(3,3);

theta = 35.2644*pi/180;
theta= 90*pi/180;
L = 1000;
vz = 1/sqrt(3) .* [ 1  1  1];
v1 = 1/sqrt(6) .* [-2  1  1];
v2 = 1/sqrt(6) .* [ 1 -2  1];
v3 = 1/sqrt(6) .* [ 1  1 -2];
l1 = L .* (cos(theta) .* vz + sin(theta) .* v1);
l2 = L .* (cos(theta) .* vz + sin(theta) .* v2);
l3 = L .* (cos(theta) .* vz + sin(theta) .* v3);
links = [1 7 -0.5 0.5 0.5 0 1 -1;
         7 2 -0.5 0.5 0.5 0 1 -1;
         3 7 0.5 -0.5 0.5 1 0 -1;
         7 4 0.5 -0.5 0.5 1 0 -1;
         5 7 0.5 0.5 -0.5 1 -1 0;
         7 6 0.5 0.5 -0.5 1 -1 0];
rn    = [-0.5 .*l1 7;
          0.5 .*l1 7;
         -0.5 .*l2 7;
          0.5 .*l2 7;
         -0.5 .*l3 7;
          0.5 .*l3 7;
          0  0  0  0];
      
maxconnections=8;
lmax = 600;
lmin = 200;
a=lmin/sqrt(6);
MU = 1.3e11;
NU = 0.309; % for BCC Mo
Ec = MU/(4*pi)*log(a/0.1);

areamin=lmin*lmin*sin(60/180*pi)*0.5; % minimum discretization area
areamax=20*areamin; % maximum discretization area
dt0=1e-10;           %maximum time step
rmax=10.0;         %maximum allowed displacement per timestep
plotfreq=1;       %plot nodes every how many steps
plim=500;          %plot x,y,z limit (nodes outside not plotted)

viewangle=[-45 45];
printfreq=1;      %print out information every how many steps
printnode=3;
%mobility='mobfcc0'; %mobility law function
mobility='mobbcc0';
integrator='int_trapezoid';
%mobility = 'mobbcc1b';
rann = 1e-1;       %annihilation distance (capture radius)
%rntol=1e-1;       %tolerance for integrating equation of motion
rntol = 0.5*rann;      % on Tom's suggestion
doremesh =1;
docollision=1;
doseparation=1;
dt=1e-10;