%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%File: input_FRsegment.m
%
%Purpose: input file for DDLab simulation
%         a straight dislocation segment as Frank-Read source
%        
%Run by:
%         input_FRsegment
%         dd3d
%
%To continue simulation, type:
%         dd3d
%
%   Section 10.4 Topological Changes
%
%Computer Simulations of Dislocations
%Wei Cai (caiwei@stanford.edu)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

totalsteps=400;

mobility='mobbcc0';

appliedstress = 1e-3 * [ 2  0  1
                         0  2 -1
                         1 -1  0 ];
        
rn=[ 1000  1000  1000  7
    -1000 -1000 -1000  7
      0    0     0     0 ];
        
links = [1 3 0.5 0.5 0.5 -1 1 0;
         3 2 0.5 0.5 0.5 -1 1 0];

MU = 1;
NU = 0.305;
maxconnections=8;
lmax = 1000;
lmin = 200;
areamin=lmin*lmin*sin(60/180*pi)*0.5; 
areamax=20*areamin;
a=lmin/sqrt(3)*0.5;
Ec = MU/(4*pi)*log(a/0.1);
dt0=1e7;  
integrator='int_trapezoid';
rann = 0.5*a;       
rntol = 0.5*rann;    
doremesh=1;
docollision=1;
doseparation=1;
plotfreq=1;       
plim=10000;         
viewangle=[45 -45 ];
printfreq=1;      
printnode=3;
rmax=100;
