%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%File: input_FRloop_notopol.m
%
%Purpose: input file for DDLab simulation
%         dislocation loop as Frank-Read source
%         without topology handling
%        
%Run by:
%         input_FRloop_notopol
%         dd3d
%
%To continue simulation, type:
%         dd3d
%
%   Section 10.3 Time Integrators
%
%Computer Simulations of Dislocations
%Wei Cai (caiwei@stanford.edu)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

totalsteps = 200;

appliedstress = -0.1 * [ 0 0 1    % sigma_xz
                         0 0 0
                         1 0 0 ];

% no topology handling
doremesh     = 0; 
docollision  = 0; 
doseparation = 0;

% initial structure,  nodal positions
rn = [  %x    y              z       flag
         0  -10.0000         0         7 %fixed
         0   -9.2000         0         0 %free
         0   -8.4000         0         0
         0   -7.6000         0         0
         0   -6.8000         0         0
         0   -6.0000         0         0
         0   -5.2000         0         0
         0   -4.4000         0         0
         0   -3.6000         0         0
         0   -2.8000         0         0
         0   -2.0000         0         0
         0   -1.2000         0         0
         0   -0.4000         0         0
         0    0.4000         0         0
         0    1.2000         0         0
         0    2.0000         0         0
         0    2.8000         0         0
         0    3.6000         0         0
         0    4.4000         0         0
         0    5.2000         0         0
         0    6.0000         0         0
         0    6.8000         0         0
         0    7.6000         0         0
         0    8.4000         0         0
         0    9.2000         0         0
         0   10.0000         0         7
         0   10.0000  -40.0000    7.0000
         0  -10.0000  -40.0000    7.0000
];

links = [
     1     2     1     0     0     0     0     1
     2     3     1     0     0     0     0     1
     3     4     1     0     0     0     0     1
     4     5     1     0     0     0     0     1
     5     6     1     0     0     0     0     1
     6     7     1     0     0     0     0     1
     7     8     1     0     0     0     0     1
     8     9     1     0     0     0     0     1
     9    10     1     0     0     0     0     1
    10    11     1     0     0     0     0     1
    11    12     1     0     0     0     0     1
    12    13     1     0     0     0     0     1
    13    14     1     0     0     0     0     1
    14    15     1     0     0     0     0     1
    15    16     1     0     0     0     0     1
    16    17     1     0     0     0     0     1
    17    18     1     0     0     0     0     1
    18    19     1     0     0     0     0     1
    19    20     1     0     0     0     0     1
    20    21     1     0     0     0     0     1
    21    22     1     0     0     0     0     1
    22    23     1     0     0     0     0     1
    23    24     1     0     0     0     0     1
    24    25     1     0     0     0     0     1
    25    26     1     0     0     0     0     1
    26    27     1     0     0     0     0     1
    27    28     1     0     0     0     0     1
    28     1     1     0     0     0     0     1
];

% simulation parameters
MU = 1;
NU = 0.3;
maxconnections = 8;
lmax = 20;
lmin = 2;
areamin = lmin*lmin*sin(60/180*pi)*0.5; 
areamax = 20*areamin;
rmax = 100;

a      = 0.1;
Ec     = 0;
rann   = 0.5*a;       
rntol  = 0.01; 
dt0    = 20; 

mobility='mobfcc1';
integrator='int_trapezoid';

% plot setting
plotfreq = 1;       
plim     = 120;         
viewangle=[0 90];

% print setting
printfreq = 1;      
printnode = 3;
