%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%File: input_Bjunct_stress.m
%
%Purpose: input file for DDLab simulation
%         unzip binary-junction by applying stress
%        
%Run by:
%         input_Bjunct_stress
%         dd3d
%
%To continue simulation, type:
%         dd3d
%
%   Section 10.4 Topological Changes
%
%Computer Simulations of Dislocations
%Wei Cai (caiwei@stanford.edu)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% if file junction_data_1.mat does not exist, run the following first
%
%input_Bjunct
%dd3d
%save junction_data_1

load junction_data_1

totalsteps=400;

%stress in coordinate system 1
sigma = [ 1 0 0
          0 0 0
          0 0 0 ] * 1e8;   %in Pa
%coordinate system 1
e1 =  [1 0 1]; e2  = [1 0 -1]; e3 = [0 2 0];
e1=e1/norm(e1); e2=e2/norm(e2); e3=e3/norm(e3); 
%coordinate system 2 (cubic coordinate system)
e1p = [1 0 0]; e2p = [0 1 0]; e3p = [0 0 1];
e1p=e1p/norm(e1p); e2p=e2p/norm(e2p); e3p=e3p/norm(e3p); 
%rotation matrix
T = [ dot(e1,e1p) dot(e1,e2p) dot(e1,e3p)
      dot(e2,e1p) dot(e2,e2p) dot(e2,e3p)
      dot(e3,e1p) dot(e3,e2p) dot(e3,e3p) ];

%Transform stress into current coordinate system  
appliedstress = rotate_tensor_2nd(sigma, T);
