%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%File: input_Bjunct_noconstr.m
%
%Purpose: input file for DDLab simulation
%         formation of binary-junction
%         ignoring glide constraint
%        
%Run by:
%         input_Bjunct_noconstr
%         dd3d
%
%To continue simulation, type:
%         dd3d
%
%   Section 10.4 Topological Changes
%
%Computer Simulations of Dislocations
%Wei Cai (caiwei@stanford.edu)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

totalsteps=100;

appliedstress = zeros(3,3);

mobility='mobfcc1';

rn = [ -2000  -1000  1000  7
        0      0     0     0
        2000   1000 -1000  7
       -1000  -1000  2000  7
        0      0     0     0
        1000   1000 -2000  7 ];
    
b1 = [  0   1   1  ]/2;
b2 = [  1  -1   0  ]/2;

n1 = [  0   0   0  ];  % no glide constraint
n2 = [  0   0   0  ];  % no glide constraint

links = [ 1 2   b1 n1
          2 3   b1 n1
          4 5   b2 n2
          5 6   b2 n2 ];

maxconnections=8;
lmax = 1000;
lmin = 200;
a=lmin/sqrt(6);
MU = 1.3e11;
NU = 0.309; % for BCC Mo
Ec = MU/(4*pi)*log(a/0.1);

areamin=lmin*lmin*sin(60/180*pi)*0.5; % minimum discretization area
areamax=20*areamin; % maximum discretization area
dt0=1e-5;           %maximum time step
rmax=10.0;         %maximum allowed displacement per timestep
plotfreq=1;       %plot nodes every how many steps
plim=2000;          %plot x,y,z limit (nodes outside not plotted)

viewangle=[60 30];
printfreq=1;      %print out information every how many steps
printnode=3;

integrator='int_trapezoid';

rann = 10;       %annihilation distance (capture radius)
%rntol=1e-1;       %tolerance for integrating equation of motion
rntol = 2*rann;      % on Tom's suggestion
rmax=30;

doremesh    =1;
docollision =1;
doseparation=1;
