function [rn,links,connectivity,linksinconnect,fseg]=separation(rn,links,connectivity,linksinconnect,fseg,mobility,MU,NU,a,Ec,mindist,appliedstress);

eps=1e-12;
[lrn,lrn2]=size(rn);

% search through connectivity list
for i=1:lrn
    c=connectivity(i,1);
    if (c>3) & (rn(i,lrn2)==0)
        % disp(sprintf('separation: node %d has %d arms',i,c));
        % a high order node has been found
        % construct the nodelist and conlist that is to be evaluated by the mobility law
        maxsplitarms=floor(0.5*c);
        % calculate the number of possible splitting modes
        numsplitmodes=0;
        for j=2:maxsplitarms
            subnumber=factorial(c)/factorial(c-j)/factorial(j);
            if (2*j==c)% this is a special case that handles mirror symmetry situations
                subnumber=0.5*subnumber;
            end
            numsplitmodes=numsplitmodes+subnumber;
        end
        %initialize the nodelist and connection list now that the number of splitting modes is known
        nodelist=i.*ones(2*numsplitmodes+1,1);
        conlist=zeros(2*numsplitmodes+1,1+c);
        %fill in the connection list with all of the possibilities
        concount=linspace(1,c,c);
        conlist(1,:)=[c concount];
        lastone=1;
        for j=2:maxsplitarms
            numsplit = factorial(c) / factorial(c-j) / factorial(j);
            splitmodes=zeros(numsplit,j);
            splitmodes=createsplitmodelist(c,j);
            if (2*j==c) % this is a special case that handles mirror symmetry situations
                numsplit=0.5*numsplit;
            end
            for k=1:numsplit
                conlist(lastone+1,:)=[ j splitmodes(k,:) zeros(1,c-j)];
                % create v such that it contains the links left behind from conlist
                v=concount;
                for m=1:j
                    v(splitmodes(k,j-m+1))=[];
                end
                
                conlist(lastone+2,:)=[ c-j v zeros(1,j)];
                lastone=lastone+2;
            end
        end
        % initialize the temporary node, links, fseg, and connectivity information for testing the different splitting modes
        rntmp=rn(i,:);
        numbcon=connectivity(i,1);
        connectivitytmp=[numbcon zeros(1,2*numbcon);ones(numbcon,1) zeros(numbcon,2*numbcon)];
        linkstmp=[];
        fsegtmp=[];
        % transfer the information about the highly connected system of nodes to the temporary structure
        for j=1:numbcon
            posi=connectivity(i,2*j+1);
            posnoti=3-posi;
            connectivitytmp(1,2*j:2*j+1)=[j posi];
            linkid=connectivity(i,2*j);
            nodenoti=links(linkid,posnoti);
            linkstmp(j,:)=links(linkid,:);
            linkstmp(j,posi)=1;
            linkstmp(j,posnoti)=j+1;
            fsegtmp(j,:)=fseg(linkid,:);
            rntmp(j+1,:)=rn(nodenoti,:);
            connectivitytmp(j+1,2:3)=[j,posnoti];
        end
        
        % calculate the forces and velocities of all of the node splitting possibilities
        
        [vntmp,fntmp]=feval(mobility,fsegtmp,rntmp,linkstmp,connectivitytmp,ones(2*numsplitmodes+1,1),conlist);
        %now that the first guess has been made we need to include the effect of a junction dislocation
        % resulting from the separation in the node force and the velocity of the node that is splitting
        % this can be accomplished by modifying the temporary data structures
        conlisttmp=conlist;
        totaltempnodes=size(rntmp,1);
        totaltemplinks=size(linkstmp,1);
        % keep the splitting direction to make sure that the direction of node motion does not change when the junction
        % dislocation effects are added
        dir=zeros(numsplitmodes,3);
        % keep information about new segment creation due to splitting
        newseg=zeros(numsplitmodes);
        for j=1:numsplitmodes
            vdiff=vntmp(2*j,:)-vntmp(2*j+1,:);
            magvdiff2=vdiff*vdiff';
            if magvdiff2>eps
                dir(j,:)=vdiff./sqrt(magvdiff2);
                junctb=zeros(1,3);
                for k=1:conlisttmp(2*j,1)
                    c1=conlisttmp(2*j,k+1);
                    junctb=junctb+(2.*connectivitytmp(1,2*c1+1)-3).*linkstmp(connectivitytmp(1,2*c1),3:5);
                end 
                if junctb*junctb'>0.0d0
                    
                    % there is a residual burgers vector so several links, nodes, connections must be added
                    connectivitytmp=[connectivitytmp zeros(totaltempnodes,2)];
                    rntmp(totaltempnodes+1:totaltempnodes+2,:)=[rntmp(1,:);rntmp(1,:)];
                    rntmp(totaltempnodes+1:totaltempnodes+2,1:3)=[rntmp(1,1:3)-mindist.*dir(j,:); rntmp(1,1:3)+mindist.*dir(j,:)];
                    plane=zeros(1,3);
                    n1=cross(dir(j,:),junctb);                        % normal determined by line direction and burgers vector  not good for screw dislocations
                    n2=cross(dir(j,:),vntmp(2*j,:)+vntmp(2*j+1,:));   % normal determined by line direction and velocity vector this option is used if a screw is found
                    if n1*n1'>eps
                        plane=n1./norm(n1);
                    elseif n2*n2'>eps
                        plane=n2./norm(n2);
                    end
                    
                    linkstmp(totaltemplinks+1:totaltemplinks+2,:)=[ 1 totaltempnodes+1 junctb plane ; totaltempnodes+2 1 junctb plane];
                    totalconnections=connectivitytmp(1,1);
                    connectivitytmp(1,2*totalconnections+2:2*totalconnections+5)=[totaltemplinks+1 1 totaltemplinks+2 2];
                    conlisttmp(2*j,1)=conlisttmp(2*j,1)+1;
                    conlisttmp(2*j,conlisttmp(2*j,1)+1)=totalconnections+1;
                    conlisttmp(2*j+1,1)=conlisttmp(2*j+1,1)+1;
                    conlisttmp(2*j+1,conlisttmp(2*j+1,1)+1)=totalconnections+2;
                    connectivitytmp(1,1)=totalconnections+2;
                    connectivitytmp(totaltempnodes+1:totaltempnodes+2,:)=[ones(2,1) zeros(2,2*totalconnections+4)];
                    connectivitytmp(totaltempnodes+1:totaltempnodes+2,2:3)=[totaltemplinks+1 2; totaltemplinks+2 1];
                    % fseg for the new links must be added 
                    % since the segment is going to be small in length we will make an approximation that the  
                    % force on the segment isdetermined by the line tension term
                    segments=[linkstmp(totaltemplinks+1:totaltemplinks+2,1:5), rntmp(linkstmp(totaltemplinks+1:totaltemplinks+2,1),1:3), rntmp(linkstmp(totaltemplinks+1:totaltemplinks+2,2),1:3)];
                    [ftemp1,ftemp2]=estforcevec(MU,NU,a,Ec,appliedstress,segments);
                    fsegtmp(totaltemplinks+1:totaltemplinks+2,:)=[ftemp1,ftemp2];
                    totaltempnodes=totaltempnodes+2;
                    totaltemplinks=totaltemplinks+2;
                    % this last part is for updated the segment forces if a new segment is created as a result of the separation
                    newseg(j)=1;
                end
            end
        end
        %now recompute the nodal forces and velocities that will be used to determine whether the node should split
        [vntmp,fntmp]=feval(mobility,fsegtmp,rntmp,linkstmp,connectivitytmp,ones(2*numsplitmodes+1,1),conlisttmp);
        splittingmode=0;
        
        Powermax=fntmp(1,:)*vntmp(1,:)';
        
        for j=1:numsplitmodes
            vdiff=vntmp(2*j,:)-vntmp(2*j+1,:);
            if dir(j,:)*vdiff'>0
                % the splitting modes has not switched directions now that the junction dislocation has been added
                % the junction should be tested  
                Powertest=fntmp(2*j,:)*vntmp(2*j,:)'+fntmp(2*j+1,:)*vntmp(2*j+1,:)';
                if ((Powertest-Powermax)>eps)
                    Powermax=Powertest;
                    splittingmode=j;
                end
            end
        end
        
        if splittingmode~=0
            % a lower energy configuration exists if the node is split
            % split the node into the lowest energy configuration
            s=conlist(2*splittingmode,2:c+1);
            k=c;
            while s(k)==0
                s(k)=[];
                k=k-1;
            end
            
            disp(sprintf('separation: node %d has %d arms',i,c));
            disp(sprintf('separation: the following connections have split off'));
            for j=1:length(s)
                disp(sprintf('separation: connection %d',s(j)));
            end
            
            vel1=vntmp(2*splittingmode,:);
            vel2=vntmp(2*splittingmode+1,:);
            vd1=vel1*vel1';
            vd2=vel2*vel2';
            if vd1>vd2
                dir=vel1./sqrt(vd1);
                posvel1=[rn(i,1:3)+(mindist*(1+eps)).*dir vel1];
                posvel2=[rn(i,1:3) vel2];
            else
                dir=vel2./sqrt(vd2);
                posvel1=[rn(i,1:3) vel1];
                posvel2=[rn(i,1:3)+(mindist*(1+eps)).*dir vel2];
            end
            [rn,links,connectivity,linksinconnect]=splitnode(rn,links,connectivity,linksinconnect,i,s,posvel1);
            rn(i,1:6)=posvel2;
            if newseg(splittingmode)==1
                % a new segment is created make an initial estimate for the forces on the new segment 
                newlinkid=size(links,1);
                segments=[links(newlinkid,1:5) rn(links(newlinkid,1),1:3) rn(links(newlinkid,2),1:3)];
                [ftemp1,ftemp2]=estforcevec(MU,NU,a,Ec,appliedstress,segments);
                fseg(newlinkid,:)=[ftemp1,ftemp2];
            end
        end
    end
end
function [splitmodes]=createsplitmodelist(nodeconnectivity,numsplitarms)
%initialize the size of splitmodes and fill with zeros
splitmodes=zeros( factorial(nodeconnectivity) / factorial(nodeconnectivity-numsplitarms) / factorial(numsplitarms) , numsplitarms );
if (numsplitarms==1)
    % if numsplitarms is 1 then the answer is simply a count from one to nodeconnectivity
    splitmodes=linspace(1,nodeconnectivity,nodeconnectivity)';
else
    % if numsplitarms is greater than one go into a recursive algorithm to build up the system
    lastone=0;
    for i=1:nodeconnectivity-numsplitarms+1
        % initialize the subslitmodes matrix b
        addlength= factorial(nodeconnectivity-i) / factorial(nodeconnectivity-i-numsplitarms+1) / factorial(numsplitarms-1);
        b=zeros(addlength,numsplitarms-1);
        % calculate the subsplitmodes with a call to splitmodes
        b=createsplitmodelist(nodeconnectivity-i,numsplitarms-1);
        % add the subspitmode list b to the growing splitmode list
        splitmodes(lastone+1:lastone+addlength,1)=i.*ones(addlength,1);
        splitmodes(lastone+1:lastone+addlength,2:numsplitarms)=i+b( 1:addlength , 1:numsplitarms-1 );
        % update the current position of the last valid line of the splitmode system
        lastone=lastone+addlength;
    end       
end


%total number of splitting options
%4 arm multinode
%may split into 3 two arm splitting modes      0.5 * n! / ( (n-2)! * 2! )       3 total
%5 arm mulitnode
%may split into 10 two arm splitting modes           n! / ( (n-2)! * 2! )      10 total
%6 arm mulitinode
%may split into 15 two arm splitting modes or        n! / ( (n-2)! * 2! )
%may split into 10 three arm spliting modes    0.5 * n! / ( (n-3)! * 3! )      25 total
%7 arm multinode
%may split into 21 two arm splitting modes or        n! / ( (n-2)! * 2! )
%may split into 35 thee arm splitting modes          n! / ( (n-3)! * 3! )      46 total
%8 arm multinode
%may split into 28 two arm splitting modes or        n! / ( (n-2)! * 2! )
%may split into 56 three arm splitting modes or      n! / ( (n-3)! * 3! )
%may split into 35 four arm splitting modes    0.5 * n! / ( (n-4)! * 4! )     119 total 
%9 arm multinode
%may split into 36 two arm splitting modes or        n! / ( (n-2)! * 2! )
%may split into 84 three arm splitting modes or      n! / ( (n-3)! * 3! )
%may split into 126 four arm splitting modes         n! / ( (n-4)! * 4! )     246 total
%10 arm multinode
%may split into 45 two arm splitting modes or        n! / ( (n-2)! * 2! )
%may split into 120 three arm splitting modes or     n! / ( (n-3)! * 3! )
%may split into 210 four arm splitting modes or      n! / ( (n-4)! * 4! )
%may split into 126 five arm splitting modes   0.5 * n! / ( (n-5)! * 5! )     501 total
% the division by 2 for some of the cases is done outside this function call when appropriate.    



function [f1,f2]=estforcevec(mu,nu,a,Ec,appliedstress,segments);
% function used to estimate the forces on an infinitesimal segment
    Diff=segments(:,9:11)-segments(:,6:8);
    L=sqrt(sum(Diff.*Diff,2));
    Linv=1./L;
    La=sqrt(L.*L+a*a);
    Lainv=1./La;
    
    t=Diff.*[Linv Linv Linv];
    omninv=1/(1-nu);
    bs=sum(segments(:,3:5).*t,2);
    bs2=bs.*bs;
    bev=segments(:,3:5)-[bs bs bs].*t;
    be2=sum(bev.*bev,2);
    S=(0.25*mu/pi).*bs.*((nu*omninv).*( log((La+L)./a)- 2.*(La-a).*Linv)- 0.5.*(La-a).*(La-a).*Linv.*Lainv);
    % Core Self Interaction Force - Torsional Contribution
    Score=2.*nu*omninv*Ec.*bs;
    Stot=S+Score;
    f2=[Stot Stot Stot].*bev;
    
    % Core Self Interaction Force - Longitudinal Component
    LTcore=(bs2 + be2.*omninv).*Ec;
    f2=f2-[LTcore LTcore LTcore].*t;
    f1=-f2;
    
    % include the pk force from the far field stress
    sigb=segments(:,3:5)*appliedstress;
    fpk(:,1)=sigb(:,2).*Diff(:,3)-sigb(:,3).*Diff(:,2);
    fpk(:,2)=sigb(:,3).*Diff(:,1)-sigb(:,1).*Diff(:,3);
    fpk(:,3)=sigb(:,1).*Diff(:,2)-sigb(:,2).*Diff(:,1);
    f2=f2+0.5.*fpk;
    f1=f1+0.5.*fpk;
% end of function

