function [f1,f2]=selfforcevec(mu,nu,a,Ec,segments)
%self force (due to self stress)
%(vectorized version)
%format of segments array:
% (n0,n1,bx,by,bz,x0,y0,z0,x1,y1,z1)


    Diff=segments(:,9:11)-segments(:,6:8);
 
    L=sqrt(sum(Diff.*Diff,2));
    Linv=1./L;
    
    La=sqrt(L.*L+a*a);
    Lainv=1./La;
    
    t=Diff.*[Linv Linv Linv];
    
    omninv=1/(1-nu);
    
    bs=sum(segments(:,3:5).*t,2);
    bs2=bs.*bs;
    bev=segments(:,3:5)-[bs bs bs].*t;
    be2=sum(bev.*bev,2);
    
    % Elastic Self Interaction Force - Torsional Contribution
    S=(0.25*mu/pi).*bs.*((nu*omninv).*( log((La+L)./a)- 2.*(La-a).*Linv)- 0.5.*(La-a).*(La-a).*Linv.*Lainv);
    % Core Self Interaction Force - Torsional Contribution
    Score=2.*nu*omninv*Ec.*bs;
    Stot=S+Score;
    f2=[Stot Stot Stot].*bev;
    
    % Core Self Interaction Force - Longitudinal Component
    LTcore=(bs2 + be2.*omninv).*Ec;
    f2=f2-[LTcore LTcore LTcore].*t;
    f1=-f2;