function fseg=segforcevec(MU,NU,a,Ec,rn,links,sigext)
%compute nodal driving force of dislocation network by stress formula
%(vectorized version)
%rn: nodal position
%links: dislocation segments (connectivity, Burgers vector)
%sigext: external stress (applied)

%segment contribution to node force

%NMAX: max number of nodes
[NMAX,m]=size(rn);
if(m~=4)
    disp('rn should have 4 columns!');
    return;
end
[LINKMAX,m]=size(links);

%construct segment list
segments=constructsegmentlist(rn,links);

%PK force due to applied stress
%t0=clock;
fpk=pkforcevec(sigext,segments);
%t=etime(clock,t0); disp(sprintf('pkforcevec time = %6.2f seconds\n',t));

%self force due to self stress
%t0=clock;
[fs0,fs1]=selfforcevec(MU,NU,a,Ec,segments);
%t=etime(clock,t0); disp(sprintf('selfforcevec time = %6.2f seconds\n',t));

%remote force due to remote stress
%t0=clock;
[fr0,fr1]=remoteforcevec(MU,NU,a,segments);
%t=etime(clock,t0); disp(sprintf('remoteforcevec time = %6.2f seconds\n',t));

%add force contributions together
fseg=[fpk, fpk]*0.5+[fs0, fs1]+[fr0, fr1];



function segments=constructsegmentlist(rn,links)

[LINKMAX,m]=size(links);

segments=zeros(LINKMAX,11);
nseg=0;
for i=1:LINKMAX,
    n0=links(i,1);
    n1=links(i,2);
    if((n0~=0)&(n1~=0))
        nseg=nseg+1;
        segments(nseg,:)=[links(i,1:5),rn(n0,1:3),rn(n1,1:3)];
    end
end
segments=segments(1:nseg,:);



function f=pkforcevec(sigext,segments)
%nodal force on dislocation segments due to applied stress sigext
%(vectorized version)
%format of segments array:
% (n0,n1,bx,by,bz,x0,y0,z0,x1,y1,z1)

[nseg,m]=size(segments);
f=zeros(nseg,3);

b=segments(:,3:5);
sigb=sigext*b';

r0=segments(:,6:8);
r1=segments(:,9:11);
r01=r1-r0;

for i=1:nseg,
    f(i,:)=cross(sigb(:,i)',r01(i,:));
end
