function [vn,fn] = mobfcc1(fseg,rn,links,connectivity,nodelist,conlist)
%mobility law function (model: FCC1)
%FCC1: velocity linear to force but remain orthogonal to glide plane
% v=f/L
% if nodelist and conlist are empty then vn is the length of rn otherwise 
% vn is the length of nodelist
eps=1e-12;

L1=size(nodelist,1);
if L1==0
    L1=size(rn,1);
    nodelist=linspace(1,L1,L1)';
    [L2,L3]=size(connectivity);
    conlist=zeros(L2,(L3-1)/2+1);
    conlist(:,1)=connectivity(:,1);
    for i=1:L2
        connumb=conlist(i,1);
        conlist(i,2:connumb+1)=linspace(1,connumb,connumb);
    end
end
for n=1:L1
    n0=nodelist(n);
    numNbrs=conlist(n,1);
    nv=zeros(numNbrs,3);
    rt=zeros(numNbrs,3);
    fn(n,:)=zeros(1,3);
    L=0;
    for i=1:numNbrs
        ii=conlist(n,i+1);
        n1=links(connectivity(n0,2*ii),3-connectivity(n0,2*ii+1));
        fn(n,:)=fn(n,:)+fseg(connectivity(n0,2*ii),3*(connectivity(n0,2*ii+1)-1)+[1:3]);
        nv(i,:)=links(connectivity(n0,2*ii),6:8);
        rt(i,:)=rn(n1,1:3)-rn(n0,1:3);
        L=L+norm(rt(i,:));
    end
    vn(n,:)=fn(n,:);
    L=L/2;
    vn(n,:)=vn(n,:)/L; %(active in mobfcc1)
    
    %orthogonalize vn to all gilde plane normal vectors
    for i=1:numNbrs
        for j=1:i-1,
            nv(i,:)=nv(i,:)-dot(nv(i,:),nv(j,:))*nv(j,:);
        end
        if(norm(nv(i,:))>eps)
            nv(i,:)=nv(i,:)/norm(nv(i,:));
        else
            nv(i,:)=0;
        end
    end
    for i=1:numNbrs
        vn(n,:)=vn(n,:)-dot(vn(n,:),nv(i,:))*nv(i,:);
    end
end

%nonlinear mobility law (relativistic effect)
%c=10;
%for n0=1:nnode,
%    fac=1./sqrt(1+dot(vn(n0,:),vn(n0,:))/c^2);
%    vn(n0,:)=vn(n0,:)*fac;
%end
