function [rn,vn,dt,fn,fseg]=int_eulerbackward(rn,dt,dt0,MU,NU,a,Ec,links,connectivity,appliedstress,rmax,rntol,mobility)
%implicit numerical integrator using the Backward Euler or Trapezoid method
%dt: suggested timestep (usually from previous iteration)
%dt0: maximum allowed timestep

%dummy variable
t=0;
rnold=rn;

%scramble rn into a single column vector
rnvec=[rn(:,1);rn(:,2);rn(:,3)]; flag=rn(:,4);

%Backward Euler
rnvec0=rnvec;

[vnvec0,fn,fseg]=drndt(t,rnvec0,flag,MU,NU,a,Ec,links,connectivity,appliedstress,mobility);
%dt=1/max(1/dt0,max(vnvec0)/rmax);
%dt=dt0;

dt1=dt;
maxiter=1;
convergent=0;
while(~convergent)
    rnvec1=rnvec0+vnvec0*dt;

    for iter=1:maxiter,
        [vnvec,fn,fseg]=drndt(t,rnvec1,flag,MU,NU,a,Ec,links,connectivity,appliedstress,mobility);
        %err=rnvec1-rnvec0-vnvec.*dt;          %backward Euler
        err=rnvec1-rnvec0-(vnvec+vnvec0)/2*dt; %trapzoid
        errmag=max(abs(err));
        disp(sprintf('iter=%d err=%e',iter,errmag));
        if(errmag<rntol)
            convergent=1;
            break;
        else
            rnvec1=rnvec1-err;
        end
    end
    
    if(convergent)
        break;
    else
        dt=dt/2;
    end
end

%unscramble rn and vn vectors
rn=[reshape(rnvec1,length(rnvec1)/3,3),flag];
vn=(rn(:,1:3)-rnold(:,1:3))/dt; % backward Euler
vn=2.*vn-reshape(vnvec0,length(vnvec0)/3,3); % trapezoidal rule modification
    
%automatically adjust time step
if((dt==dt1)&(iter==1))
    dt=min(dt1*1.2,dt0);
end