theta = 60*pi/180;
L = 1000;
vz = 1/sqrt(3) .* [ 1  1  1];
v1 = 1/sqrt(6) .* [-2  1  1];
v2 = 1/sqrt(6) .* [ 1 -2  1];
v3 = 1/sqrt(6) .* [ 1  1 -2];
l1 = L .* (cos(theta) .* vz + sin(theta) .* v1);
l2 = L .* (cos(theta) .* vz + sin(theta) .* v2);
l3 = L .* (cos(theta) .* vz + sin(theta) .* v3);
links = [1 7 -0.5 0.5 0.5 0 1 -1;
         7 2 -0.5 0.5 0.5 0 1 -1;
         3 7 0.5 -0.5 0.5 1 0 -1;
         7 4 0.5 -0.5 0.5 1 0 -1;
         5 7 0.5 0.5 -0.5 1 -1 0;
         7 6 0.5 0.5 -0.5 1 -1 0];
rn    = [-0.5 .*l1 7;
          0.5 .*l1 7;
         -0.5 .*l2 7;
          0.5 .*l2 7;
         -0.5 .*l3 7;
          0.5 .*l3 7;
          0  0  0  0];
      
maxconnections=8;
lmax = 100;
lmin = 10;
a=lmin/sqrt(6);
MU = 1.3e11;
NU = 0.309; % for BCC Mo
Ec = MU/(4*pi)*log(a/0.1);
totalsteps=20000;
areamin=lmin*lmin*sin(60/180*pi)*0.5; % minimum discretization area
areamax=20*areamin; % maximum discretization area
dt0=1e-5;           %maximum time step
rmax=10.0;         %maximum allowed displacement per timestep
plotfreq=1;       %plot nodes every how many steps
plim=500;          %plot x,y,z limit (nodes outside not plotted)
appliedstress = zeros(3,3);
%sigma = [ 1 0 0 ; 0 1 0 ; 0 0 -2];
%sigma = [ 0 0 0 ; 0 0 0 ; 0 0  1];
%sigma = [ 0 1 0 ; 1 0 1 ; 0 1 0];
sigma = [ 1 -1 0 ; -1 1 0 ; 0 0 0];
viewangle=[-45 45];
printfreq=1;      %print out information every how many steps
printnode=3;
%mobility='mobfcc0'; %mobility law function
mobility='mobbcc0';
integrator='int_eulerbackward';
%mobility = 'mobbcc1b';
rann = 1.0e-1;       %annihilation distance (capture radius)
%rntol=1e-1;       %tolerance for integrating equation of motion
rntol = 20*rann;      % on Tom's suggestion
doremesh =1;
docollision=1;
doseparation=1;
dt=1e-10;